/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.converter.sys;

import java.io.Serializable;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Converter;
import org.zkoss.util.Locales;
import org.zkoss.util.TimeZones;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;

public class FormattedTemporalConverter<T extends TemporalAccessor>
implements Converter<String, T, Component>,
Serializable {
    private static final long serialVersionUID = 5761640535398518021L;
    private final TemporalQuery<T> parseTo;

    public FormattedTemporalConverter(TemporalQuery<T> parseTo) {
        this.parseTo = parseTo;
    }

    @Override
    public String coerceToUi(T beanProp, Component component, BindContext ctx) {
        String format = (String)ctx.getConverterArg("format");
        if (format == null) {
            throw new NullPointerException("format attribute not found");
        }
        return beanProp == null ? null : FormattedTemporalConverter.getLocalizedDateTimeFormatter(format).format((TemporalAccessor)beanProp);
    }

    @Override
    public T coerceToBean(String compAttr, Component component, BindContext ctx) {
        String format = (String)ctx.getConverterArg("format");
        if (format == null) {
            throw new NullPointerException("format attribute not found");
        }
        try {
            return (T)(compAttr == null ? null : (TemporalAccessor)FormattedTemporalConverter.getLocalizedDateTimeFormatter(format).parse((CharSequence)compAttr, this.parseTo));
        }
        catch (DateTimeParseException e) {
            throw UiException.Aide.wrap((Throwable)e);
        }
    }

    private static DateTimeFormatter getLocalizedDateTimeFormatter(String formatPtn) {
        return DateTimeFormatter.ofPattern(formatPtn, Locales.getCurrent()).withZone(TimeZones.getCurrent().toZoneId());
    }
}

